/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.vterm;

import com.ibm.hsc.common.util.BuildCommandPacket;
import com.ibm.hsc.vterm.HSCVtermReadThread;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.net.Socket;
import java.sql.Timestamp;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class HSCVtermPacketThread
implements Runnable {
    Socket socket = null;
    Socket lcesocket = null;
    String hostname = "";
    String port = "";
    String cfgstring = "";
    String lparid = "";
    String sessionid = "";
    boolean XON = false;
    DataInputStream vterminsoc = null;
    DataOutputStream vtermoutsoc = null;
    DataInputStream lceinsoc = null;
    DataOutputStream lceoutsoc = null;
    boolean openTerm = false;
    boolean noStrip = false;
    boolean debugOn = false;
    public static boolean bufferFull = false;

    public HSCVtermPacketThread(Socket socket) {
        this.socket = socket;
    }

    public void run() {
        HSCVtermReadThread hSCVtermReadThread = null;
        Thread thread = null;
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[32];
        boolean bl = false;
        File file = new File("/var/hsc/log/.DEBUG_VTERM");
        if (file.exists()) {
            this.debugOn = true;
        }
        try {
            this.vterminsoc = new DataInputStream(this.socket.getInputStream());
            this.vtermoutsoc = new DataOutputStream(this.socket.getOutputStream());
            int n = 0;
            byte[] byArray3 = new byte[1];
            while (n < 4) {
                this.vterminsoc.readFully(byArray3);
                if (byArray3[0] == 70) {
                    if (++n != 4) continue;
                    break;
                }
                if (byArray3[0] == 88) {
                    if (n != 3) continue;
                    this.openTerm = true;
                    break;
                }
                if (byArray3[0] == 90) {
                    if (n != 3) continue;
                    this.noStrip = true;
                    break;
                }
                n = 0;
            }
            n = 0;
            byte[] byArray4 = new byte[16];
            n = 0;
            while (n < 16) {
                this.vterminsoc.readFully(byArray3);
                if (byArray3[0] == 42) break;
                byArray4[n] = byArray3[0];
                ++n;
            }
            String string = new String(byArray4, 0, n++);
            Integer n2 = new Integer(string);
            byte[] byArray5 = new byte[n2.intValue()];
            this.vterminsoc.readFully(byArray5);
            String string2 = new String(byArray5);
            this.getCmdData(string2);
            this.lcesocket = new Socket(this.hostname, 9734);
            this.lceinsoc = new DataInputStream(this.lcesocket.getInputStream());
            this.lceoutsoc = new DataOutputStream(this.lcesocket.getOutputStream());
            byte[] byArray6 = this.buildConnectCommand(this.cfgstring);
            if (this.debugOn) {
                System.out.println("Connect string " + byArray6);
            }
            this.lceoutsoc.write(byArray6, 0, byArray6.length);
            this.lceoutsoc.flush();
            byArray3 = new byte[2];
            this.lceinsoc.readFully(byArray3);
            int n3 = ~(byArray3[0] << 8 | byArray3[1] & 0xFF) + 1;
            if (n3 > 1) {
                byte[] byArray7 = new byte[n3];
                this.lceinsoc.readFully(byArray7);
                String string3 = new String(byArray7, 0, n3 - 1);
                if (!string3.equals(this.cfgstring)) {
                    System.out.println("CEC not found in LCE");
                }
            } else {
                System.out.println("CEC not found in LCE len < 1");
            }
            hSCVtermReadThread = new HSCVtermReadThread(this);
            thread = new Thread(hSCVtermReadThread);
            thread.start();
            if (this.openTerm) {
                this.lceoutsoc.write(this.sendOpen());
            }
            this.lceoutsoc.write(this.buildXonPacket());
            while (true) {
                if (!thread.isAlive()) {
                    if (this.debugOn) {
                        System.out.println(" reader not alive ");
                    }
                    this.cleanup();
                    return;
                }
                int n4 = this.vterminsoc.read(byArray, 0, 32);
                if (n4 > 0) {
                    if (this.debugOn) {
                        System.out.print(new Timestamp(System.currentTimeMillis()));
                        System.out.println(" " + this.cfgstring + " " + this.lparid + " From Terminal ");
                        int n5 = 0;
                        while (n5 < n4) {
                            System.out.print((char)byArray[n5] + " ");
                            ++n5;
                        }
                        System.out.println("");
                    }
                    int n6 = n4;
                    n = 0;
                    while (n < n4) {
                        if (byArray[n] == 10) {
                            --n6;
                        }
                        ++n;
                    }
                    if (n6 != n4 && !this.noStrip) {
                        n = 0;
                        int n7 = 0;
                        while (n < n4) {
                            if (byArray[n] != 10) {
                                byArray2[n7] = byArray[n];
                                ++n7;
                            }
                            ++n;
                        }
                    } else {
                        n = 0;
                        while (n < n4) {
                            byArray2[n] = byArray[n];
                            ++n;
                        }
                    }
                    do {
                        if (bufferFull) {
                            this.unSetWait();
                            Thread.sleep(1L);
                            if (this.debugOn) {
                                System.out.println("Bufferfull: SLEEP");
                            }
                        }
                        this.lceoutsoc.write(this.buildSendTTYCmd(byArray2, n6));
                        if (this.debugOn) {
                            System.out.print(new Timestamp(System.currentTimeMillis()));
                            System.out.print(" " + this.cfgstring + " " + this.lparid + " TO CSP: ");
                            int n8 = 0;
                            while (n8 < n6) {
                                System.out.print((char)byArray2[n8]);
                                ++n8;
                            }
                            System.out.println("");
                        }
                        this.lceoutsoc.flush();
                        if (!bufferFull) continue;
                        this.unSetWait();
                        Thread.sleep(1L);
                        if (!this.debugOn) continue;
                        System.out.println("Bufferfull: SLEEP");
                    } while (bufferFull);
                    continue;
                }
                if (n4 == -1) break;
            }
            thread.interrupt();
            thread = null;
            this.cleanup();
            return;
        }
        catch (Exception exception) {
            if (this.debugOn) {
                System.out.println("Writer caught " + exception);
            }
            if (thread != null && thread.isAlive()) {
                thread.interrupt();
                thread = null;
            }
            this.cleanup();
            return;
        }
    }

    public void cleanup() {
        try {
            if (this.lceoutsoc != null) {
                this.lceoutsoc.close();
                this.lceoutsoc = null;
            }
            if (this.lceinsoc != null) {
                this.lceinsoc.close();
                this.lceinsoc = null;
            }
            if (this.vterminsoc != null) {
                this.vterminsoc.close();
                this.vterminsoc = null;
            }
            if (this.vtermoutsoc != null) {
                this.vtermoutsoc.close();
                this.vtermoutsoc = null;
            }
            if (this.lcesocket != null) {
                this.lcesocket.close();
                this.lcesocket = null;
            }
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void getCmdData(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "*";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*", true);
        try {
            this.hostname = stringTokenizer.nextToken();
            this.port = stringTokenizer.nextToken();
            if (this.port.equals(string6)) {
                this.port = stringTokenizer.nextToken();
            }
            if ((this.lparid = stringTokenizer.nextToken()).equals(string6)) {
                this.lparid = stringTokenizer.nextToken();
            }
            if ((string2 = stringTokenizer.nextToken()).equals(string6)) {
                string2 = stringTokenizer.nextToken();
            }
            if ((string3 = stringTokenizer.nextToken()).equals(string6)) {
                string3 = stringTokenizer.nextToken();
            }
            if ((this.sessionid = stringTokenizer.nextToken()).equals(string6)) {
                this.sessionid = stringTokenizer.nextToken();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.cfgstring = string3.equals(string6) ? string2 + "*" : string2 + "*" + string3;
    }

    public byte[] buildConnectCommand(String string) {
        int n = string.length();
        byte[] byArray = new byte[n + 6];
        byte[] byArray2 = new byte[n];
        byArray2 = string.getBytes();
        byArray[0] = -1;
        byArray[1] = 2;
        byArray[2] = (byte)(n + 3 & 0xFF);
        byArray[3] = Byte.parseByte(this.lparid);
        byArray[4] = Byte.parseByte(this.sessionid);
        int n2 = 0;
        while (n2 < byArray2.length) {
            byArray[n2 + 5] = byArray2[n2];
            ++n2;
        }
        byArray[n + 5] = 0;
        return byArray;
    }

    public byte[] buildXonPacket() {
        byte[] byArray = null;
        String[] stringArray = new String[]{Integer.toHexString(Integer.parseInt(this.lparid)), this.sessionid, "0"};
        try {
            byArray = BuildCommandPacket.buildCommand("SET_LPAR_TERMINAL_XON_VALUE", stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] buildXoffPacket() {
        byte[] byArray = null;
        String[] stringArray = new String[]{Integer.toHexString(Integer.parseInt(this.lparid)), this.sessionid, "1"};
        try {
            byArray = BuildCommandPacket.buildCommand("SET_LPAR_TERMINAL_XON_VALUE", stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    public byte[] buildSendTTYCmd(byte[] byArray, int n) {
        byte[] byArray2 = null;
        String[] stringArray = new String[]{Integer.toHexString(Integer.parseInt(this.lparid)), this.sessionid, new String(byArray, 0, n)};
        try {
            byArray2 = BuildCommandPacket.buildCommand("SEND_TTY_DATA_TO_LPAR", stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray2;
    }

    public byte[] sendOpen() {
        byte[] byArray = null;
        String[] stringArray = new String[]{Integer.toHexString(Integer.parseInt(this.lparid))};
        try {
            byArray = BuildCommandPacket.buildCommand("OPEN_VIRTUAL_TTY", stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    public static void setWait() {
        bufferFull = true;
    }

    public void unSetWait() {
        bufferFull = false;
    }
}

